# 🏠 Principles Sharing Website - Complete Setup Guide

**A modern, bilingual PHP-based community platform for sharing life principles with advanced customization**

---

## 📋 Table of Contents
1. [Quick Start](#quick-start)
2. [System Requirements](#system-requirements)
3. [Installation Steps](#installation-steps)
4. [Configuration Guide](#configuration-guide)
5. [Features Overview](#features-overview)
6. [Customization Options](#customization-options)
7. [Troubleshooting](#troubleshooting)
8. [Advanced Configuration](#advanced-configuration)

---

## 🚀 Quick Start

### For Beginners (5 minutes)
1. **Download** the source code
2. **Upload** all files to your web server
3. **Edit** `settings.php` with your preferences
4. **Customize** `landing.php` with your content
5. **Visit** your website - it's ready!

### What You Get
- ✅ **Complete Community Platform** - Users, profiles, content sharing
- ✅ **Strict Bilingual System** - English + ONE other language only
- ✅ **Advanced Color Customization** - Per-page text colors, button colors, backgrounds
- ✅ **Enhanced Moderation** - Approve/reject with proper redirects and messaging
- ✅ **Improved User Experience** - Two-step signup, profile editing, email privacy
- ✅ **No Database Required** - File-based storage (JSON)
- ✅ **Instant Deployment** - Works on any PHP hosting

---

## 🖥️ System Requirements

### Minimum Requirements
- **PHP**: 7.4 or higher
- **Web Server**: Apache, Nginx, or similar
- **Storage**: 50MB free space
- **Permissions**: Write access to project folder

### Recommended
- **PHP**: 8.0+
- **HTTPS**: SSL certificate for security
- **Backup**: Regular file backups

---

## 📦 Installation Steps

### Step 1: Download & Upload
```bash
# Download the source code
wget your-domain.com/start.zip

# Extract to your web directory
unzip start.zip -d /path/to/your/website/
```

### Step 2: Set Permissions
```bash
# Make sure PHP can write to these files
chmod 666 users.json
chmod 666 principles.json
chmod 755 .
```

### Step 3: Essential Configuration
Edit `settings.php` and change these critical settings:

```php
// 1. CHANGE YOUR SITE NAME
'site_name' => 'Your Site Name Here',

// 2. ADD YOUR USER ID AS MODERATOR (get this after creating account)
'MODERATORS' => [
    'your_user_id_here',  // You'll get this after signup
],

// 3. SET YOUR TIMEZONE
'timezone' => 'America/New_York',  // Change to your timezone

// 4. CONFIGURE BILINGUAL SYSTEM
'auto_detect' => true,                 // Auto-detect browser language
'other_language_code' => 'fr',         // ONLY one other language allowed
```

### Step 4: Customize Landing Page Content
Edit `landing.php` to customize your homepage:

```php
// Add your prescription/content in both languages
'en' => [
    'title' => 'Your Title',
    'content' => [
        'IMAGE: https://your-image-url.com/image.jpg',
        'Your main content here...',
        'LINK: /start.zip Download Source Code',
    ]
],
```

### Step 5: Test Your Installation
1. Visit your website in a browser
2. Create your first user account (note the two-step signup process)
3. Check your profile URL for your user_id
4. Add your user_id to MODERATORS in settings.php
5. Test principle creation and moderation features

---

## 📋 Configuration Guide

### Basic Site Information
```php
'SITE_SETTINGS' => [
    'site_name' => 'Your Site Name',           // Change this!
    'timezone' => 'UTC',                       // Your timezone
],
```

### Add Your Moderators (IMPORTANT: Use User IDs, not usernames!)
```php
'MODERATORS' => [
    '2970089823',        // CHANGE THIS to your user_id!
    // 'another_mod_id',   // Add more moderator user_ids here
],
```

**How to find your User ID:**
1. Create an account on your site
2. Check the `users.json` file
3. Find your username and copy the `user_id` value
4. Add that user_id to the MODERATORS array above

### Customize Colors (NEW!)
```php
'COLORS' => [
    'color1' => '#ff6b6b',  // Card color 1 (red)
    'color2' => '#4ecdc4',  // Card color 2 (teal)
    'color3' => '#45b7d1',  // Card color 3 (blue)
    'color4' => '#96ceb4',  // Card color 4 (green)
    'color5' => '#feca57',  // Card color 5 (yellow)
    
    // Global text colors for different pages
    'text_color_principles' => '#333333',   // Principles page text
    'text_color_walkers' => '#333333',      // Walkers page text
    'text_color_profile' => '#333333',      // Profile page text
    'text_color_prescription' => '#333333', // Landing page text
],
```

### Customize Button Names & Text
#### Customize Button Names & Text
```php
'INTERFACE_TEXT' => [
    'en' => [
        'prescription' => 'Prescription',  // Landing page button
        'principles' => 'Principles',     // Change to 'Wisdom' or 'Rules'
        'login_signup' => 'Start',        // Change to 'Sign In' or 'Login'
        'walkers' => 'Walkers',          // Change to 'Members' or 'Users'
        // All error and success messages are here too!
        'error_password_mismatch' => 'Passwords do not match',
        'success_profile_updated' => '✅',
        // ... modify any text you want
    ],
    'fr' => [
        // French translations (complete set included)
        'prescription' => 'Prescription',
        'principles' => 'Principes',
        'error_password_mismatch' => 'Les mots de passe ne correspondent pas',
        // ... all French versions included
    ],
],
```

### 3. Configure Landing Page Content (NEW!)
Edit `landing.php` to customize your multilingual landing page:

```php
$LANDING_CONTENT = [
    'en' => [
        'title' => 'Welcome to Our Principles Community',
        'content' => [
            'Your welcome message here...',
            '<h3>Section Title</h3>',
            'IMAGE: https://your-image-url.com/image.jpg',
            'LINK: https://your-download.com/file.pdf Download Guide',
            // Add more content lines...
        ]
    ],
    'fr' => [
        'title' => 'Bienvenue dans Notre Communauté',
        'content' => [
            // French version of your content...
        ]
    ],
];
```

**Special Syntax:**
- `IMAGE: [URL]` - Displays an image
- `LINK: [URL] [Text]` - Creates a download button
- HTML tags supported: `<h3>`, `<strong>`, etc.
- Empty lines become line breaks

### 4. Language Settings
The system supports English and French by default with automatic browser detection. Languages are managed in both `settings.php` (UI text) and `landing.php` (landing content).

**To add a new language:**
1. In `settings.php`: Add your language section to `INTERFACE_TEXT`
2. In `landing.php`: Add your language section to `LANDING_CONTENT`
3. Copy all text keys and translate them
4. The system will automatically detect and use your new language

### 5. Important Notes
- **User IDs vs Usernames**: The system uses user_ids for moderators (more secure)
- **Mobile-First Design**: Fixed 400px width for consistent experience across devices
- **File Storage**: All data is stored in JSON files (`users.json`, `principles.json`)
- **No Database**: This is a file-based system, no MySQL/database required
- **Dynamic Colors**: Cards and UI elements use your custom color scheme
- **Multilingual**: Landing page content separate from UI text for better organization

## 🎯 That's It!

Your website will automatically:
- ✅ Work on any domain (auto-detects URL)
- ✅ Use your custom settings from `settings.php`
- ✅ Display bilingual landing page from `landing.php`
- ✅ Apply your custom colors dynamically
- ✅ Recognize moderators by their user_id
- ✅ Display in English/French with browser detection
- ✅ Use your custom text and button labels
- ✅ Store all data in JSON files (no database needed)
- ✅ Provide mobile-first responsive design

## 🔧 Advanced Customization

### File Structure Overview
```
/your-website/
├── settings.php          # Main configuration (colors, text, moderators)
├── landing.php           # Landing page content (multilingual)
├── index.php            # Landing page (was prescription.php)
├── principles.php       # Principles listing (was index.php)
├── profile.php          # User profiles
├── walkers.php          # User directory
├── signup.php           # User registration
├── user_functions.php   # Core functions
├── dynamic-styles.php   # Dynamic CSS generator
├── style.css           # Base styles
├── users.json          # User data
├── principles.json     # Principles data
└── SETUP_GUIDE.md      # This guide
```

### Color Customization
The system uses 5 rotating colors for cards and supports custom text colors for each page. Colors are applied dynamically via `dynamic-styles.php`.

### Custom Domain Setup
No code changes needed! The system automatically detects your domain.

## 🆘 Troubleshooting

### Common Issues
1. **Text not changing?** 
   - Check you're editing the correct language section in `settings.php`
   - Clear browser cache and refresh

2. **Landing page not updating?**
   - Edit `landing.php` (not `landing.txt` - that's been replaced)
   - Check PHP syntax in `landing.php`

3. **Colors not applying?**
   - Verify `dynamic-styles.php` is accessible
   - Check color values are valid hex codes in `settings.php`

4. **Site broken?** 
   - Check for PHP syntax errors in `settings.php` and `landing.php`
   - Ensure file permissions allow PHP to read/write JSON files

5. **Moderator controls not working?**
   - Use `user_id` not `username` in MODERATORS array
   - Find your `user_id` in `users.json` after creating an account

### File Permissions
Ensure your web server can read/write these files:
- `users.json` (user data)
- `principles.json` (principles data)
- All `.php` files (readable)

## 🌍 Supported Languages
- **English (en)** - Default
- **Add your own** - Copy the structure in both `settings.php` and `landing.php`

## 📱 Mobile-First Design
The website uses a fixed 400px width design that works consistently across all devices, providing a focused mobile-first experience.

## 🎨 Features Summary
- ✅ **Multilingual Landing Page** - Separate content management
- ✅ **Dynamic Color System** - 5 customizable card colors + text colors
- ✅ **Mobile-First Design** - Consistent 400px width experience
- ✅ **User Management** - Registration, profiles, moderation
- ✅ **Principle Sharing** - Submit, approve/reject system
- ✅ **File-Based Storage** - No database required
- ✅ **Auto Language Detection** - Browser-based with fallbacks
- ✅ **Comprehensive Translation** - All text and messages localized

---
*Your website is now ready to use! Users can register, share principles, and enjoy your fully customized multilingual experience.*
