<?php
/**
 * Dynamic Styles Generator
 * Generates CSS based on settings.php color configuration
 */

// Include settings
require_once 'settings.php';

// Set content type to CSS
header('Content-Type: text/css');

// Get color settings
$principles_colors = getSetting('COLORS.principles_cards', []);
$walkers_colors = getSetting('COLORS.walkers_rows', []);

// Generate CSS for principles cards - cycle through 5 colors
if (!empty($principles_colors)) {
    // First, set default background for all principle cards
    echo ".principles-page .principle-card {\n";
    echo "    background-color: {$principles_colors[0]} !important;\n";
    echo "}\n\n";
    
    // Then apply specific colors for each position in the cycle
    foreach ($principles_colors as $index => $color) {
        $nth = $index + 1;
        echo ".principles-page .principle-card:nth-child(5n+{$nth}) {\n";
        echo "    background-color: {$color} !important;\n";
        echo "}\n\n";
    }
}

// Generate CSS for walkers table rows - cycle through 5 colors
if (!empty($walkers_colors)) {
    // First, set default background for all walkers rows
    echo ".walkers-table tbody tr {\n";
    echo "    background-color: {$walkers_colors[0]} !important;\n";
    echo "}\n\n";
    
    // Then apply specific colors for each position in the cycle
    foreach ($walkers_colors as $index => $color) {
        $nth = $index + 1;
        echo ".walkers-table tbody tr:nth-child(5n+{$nth}) td {\n";
        echo "    background-color: {$color} !important;\n";
        echo "}\n\n";
    }
}

// Override any hardcoded colors in CSS
echo "/* Override hardcoded colors */\n";
echo ".principle-card:nth-child(2n),\n";
echo ".principle-card:nth-child(3n),\n";
echo ".principle-card:nth-child(4n),\n";
echo ".principle-card:nth-child(5n) {\n";
// echo "    background: unset !important;\n";
echo "}\n\n";

// Generate CSS for per-page text colors
$text_color_principles = getSetting('COLORS.text_color_principles', '#ffffff');
$text_color_walkers = getSetting('COLORS.text_color_walkers', '#ffffff');
$text_color_signup = getSetting('COLORS.text_color_signup', '#333333');
$text_color_global = getSetting('COLORS.text_color_global', '#ffffff');

echo "/* Per-page text color settings */\n";

// Principles page text colors
echo ".principles-page .principle-card .principle-title,\n";
echo ".principles-page .principle-card .principle-desc,\n";
echo ".principles-page .principle-card .principle-meta,\n";
echo ".principles-page .principle-card .principle-meta .meta-username {\n";
echo "    color: {$text_color_principles} !important;\n";
echo "}\n\n";

// Walkers page text colors
echo ".walkers-table,\n";
echo ".walkers-table th,\n";
echo ".walkers-table td,\n";
echo ".walker-username-link {\n";
echo "    color: {$text_color_walkers} !important;\n";
echo "}\n\n";

// Signup page text colors
echo ".auth-form,\n";
echo ".auth-form input,\n";
echo ".error-message {\n";
echo "    color: {$text_color_signup} !important;\n";
echo "}\n\n";

// Global fallback text colors
echo "body,\n";
echo ".container,\n";
echo ".main-content {\n";
echo "    color: {$text_color_global} !important;\n";
echo "}\n\n";

// Generate CSS for profile text color
$text_color_profile = getSetting('COLORS.text_color_profile', '#000000');

echo "/* Profile text color settings */\n";
echo ".profile-page .principle-title,\n";
echo ".profile-page .principle-desc{\n";
echo "    color: {$text_color_profile} !important;\n";
echo "}\n\n";

// Generate CSS for prescription text color
$text_color_prescription = getSetting('COLORS.text_color_prescription', '#000000');
echo "/* Prescription text color settings */\n";
echo ".landing-title,\n";
echo ".prescription-content,\n";
echo ".prescription-content h2,\n";
echo ".prescription-content h3,\n";
echo ".prescription-content p,\n";
echo ".prescription-content li{\n";
echo "    color: {$text_color_prescription} !important;\n";
echo "}\n\n";

// Generate CSS for navbar button colors
$navbar_button_text_color = getSetting('COLORS.navbar_button_text_color', '#ffffff');
$navbar_button_bg_color = getSetting('COLORS.navbar_button_bg_color', '#007bff');

echo "/* Navbar button colors */\n";
echo ".navbar .nav-link {\n";
echo "    color: {$navbar_button_text_color} !important;\n";
echo "    background-color: {$navbar_button_bg_color} !important;\n";
echo "}\n\n";

// Generate CSS for profile and login button colors
$profile_button_text_color = getSetting('COLORS.profile_button_text_color', '#ffffff');
$profile_button_bg_color = getSetting('COLORS.profile_button_bg_color', '#f9a1b0');
$login_button_text_color = getSetting('COLORS.login_button_text_color', '#ffffff');
$login_button_bg_color = getSetting('COLORS.login_button_bg_color', '#f9a1b0');

echo "/* Profile and Login button colors */\n";
echo ".nav-button.profile-btn {\n";
echo "    color: {$profile_button_text_color} !important;\n";
echo "    background-color: {$profile_button_bg_color} !important;\n";
echo "}\n\n";

echo ".nav-button.login-btn,\n";
echo ".auth-form .save-btn {\n";
echo "    color: {$login_button_text_color} !important;\n";
echo "    background-color: {$login_button_bg_color} !important;\n";
echo "}\n\n";

// Generate CSS for container background colors
$body_background_color = getSetting('COLORS.body_background_color', '#1a1a1a');
$container_background_color = getSetting('COLORS.container_background_color', '#fff3d6');

echo "/* Container background color settings */\n";
echo "body {\n";
echo "    background-color: {$body_background_color} !important;\n";
echo "}\n\n";

echo ".walkers-container,\n";
echo ".profile-info-block,\n";
echo ".profile-principles-block,\n";
echo ".principles-bg,\n";
echo ".prescription-content\n";
echo " {\n";
echo "    background-color: {$container_background_color} !important;\n";
echo "}\n\n";

?>
