<?php
/**
 * 🏠 PRINCIPLES WEBSITE - MAIN CONFIGURATION FILE
 * ===============================================
 * 
 * This is the SINGLE SOURCE OF TRUTH for all website configuration!
 * Everything is centralized here for maximum customization and control.
 * 
 * 📝 WHAT YOU CAN CUSTOMIZE:
 * - Site name and basic information
 * - Moderator user IDs (who can approve/reject principles)
 * - Advanced color system: per-page text colors, button colors, backgrounds
 * - Complete bilingual interface text (English + one other language)
 * - Button labels, icons, and interface elements
 * - Timezone and regional settings
 * - Language detection and auto-switching behavior
 * 
 * 🔧 HOW TO USE:
 * 1. Edit the values in the $SETTINGS array below
 * 2. Save this file
 * 3. Refresh your website - changes apply immediately
 * 4. No database required - all settings are file-based
 * 
 * 🎨 NEW ADVANCED FEATURES:
 * - Per-page text color control (signup, profile, principles, walkers, etc.)
 * - Separate button colors for profile/login buttons (pink theme support)
 * - Dynamic CSS generation from these settings
 * - Enhanced user experience with two-step signup validation
 * - Improved moderation system with proper redirects
 * 
 * 🚨 IMPORTANT NOTES:
 * - Use single quotes for text values to avoid conflicts
 * - Test your changes on a staging site first if possible
 * - This file contains ALL configuration - no other config files needed
 * 
 * 🌐 STRICT BILINGUAL SYSTEM (ENGLISH + ONE OTHER LANGUAGE ONLY):
 * - This system is designed to support EXACTLY TWO LANGUAGES: English + One Other
 * - English ('en') is always the primary language
 * - One configurable 'other' language (e.g., French, Spanish, German, etc.)
 * - Browser auto-detection chooses between these two languages automatically
 * - DO NOT add more than two languages - the system architecture is bilingual-only
 * - To change the 'other' language, modify 'other_language_code' below
 * - Landing page content is managed separately in landing.php
 */

// =============================================================================
// 🏠 BASIC SITE INFORMATION - CHANGE THESE FIRST!
// =============================================================================
$SETTINGS = [
    'SITE_SETTINGS' => [
        'site_name' => 'Principles',                    // CHANGE THIS!
        'timezone' => 'UTC',                            // Your timezone
    ],

    // =============================================================================
    // 👮 MODERATORS - ADD YOUR USER_ID HERE!
    // =============================================================================
    'MODERATORS' => [
        //'1234567890',   // Add your user id like this
        //'INSERT USER ID HERE',      // Uncomment and CHANGE THIS to your user_id!
        //'INSERT USER ID HERE',   // Uncomment and add as needed
    ],

    // =============================================================================
    // 🎨 APPEARANCE - CHOOSE YOUR STYLE!
    // =============================================================================
    'UI_SETTINGS' => [
        'principles_per_page' => 10,
    ],

    // =============================================================================
    // 🌈 DYNAMIC COLORS - CUSTOMIZE CARD AND ROW COLORS!
    // =============================================================================
    'COLORS' => [
        // Principles card colors (cycle through these 5 colors)
        'principles_cards' => [
            '#AFC1AC',  
            '#CAA19C',  
            '#9DA2C6',  
            '#91B7BF',  
            '#C5B8AE',  
        ],
        
        // Walkers page row colors (cycle through these 5 colors)
        'walkers_rows' => [
            '#AFC1AC',  
            '#CAA19C',  
            '#9DA2C6',  
            '#91B7BF',  
            '#C5B8AE',  
        ],
        
        // Per-page text color settings
        'text_color_prescription' => '#000000',  // Black text for prescription/landing page
        'text_color_principles' => '#ffffff',    // White text for principles page
        'text_color_walkers' => '#ffffff',       // White text for walkers page
        'text_color_profile' => '#000000',       // Black text for profile page
        'text_color_signup' => '#333333',        // Dark gray text for signup page
        'text_color_global' => '#ffffff',        // Default/fallback text color
        
        // Navbar button colors
        'navbar_button_text_color' => '#ffffff',  // White text for navbar buttons
        'navbar_button_bg_color' => '#007bff',    // Blue background for navbar buttons
        // Profile and Login button colors (pink shade)
        'profile_button_text_color' => '#ffffff', // White text for profile button
        'profile_button_bg_color' => '#f9a1b0',   // Pink background for profile button
        'login_button_text_color' => '#ffffff',   // White text for login button
        'login_button_bg_color' => '#f9a1b0',     // Pink background for login button
        
        // Container background colors
        'body_background_color' => '#e3e6f5',     // Dark background for body
        'container_background_color' => '#fff3d6', // Light cream background for containers
    ],

    // =============================================================================
    // 🌍 BILINGUAL SYSTEM - ENGLISH + ONE OTHER LANGUAGE
    // =============================================================================
    'LANGUAGES' => [
        'supported' => ['en', 'other'],        // Only English and one other language allowed
        'default' => 'en',                     // Default language is always English
        'auto_detect' => true,                 // Auto-detect from browser
        'other_language_code' => 'fr',         // CHANGE THIS: Language code for "other" (fr, es, de, etc.)
    ],

    // =============================================================================
    // 🗣️ INTERFACE TEXT - ALL WEBSITE TEXT IN ENGLISH & "Other" Language
    // =============================================================================
    'INTERFACE_TEXT' => [
        'en' => [
            // Navigation
            'prescription' => 'Prescription',
            'principles' => 'Principles',
            'walkers' => 'Walkers', 
            'profile' => 'Profile',
            'logout' => 'Logout',
            'login_signup' => 'Go',
            
            // Authentication
            'login' => 'Login',
            'signup' => 'Sign Up',
            'create_account' => 'Create Account',
            'username' => 'Username',
            'email' => 'Email',
            'password' => 'Password',
            'confirm_password' => 'Confirm Password',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            
            // Actions & Buttons
            'submit' => 'Submit',
            'cancel' => 'Cancel',
            'save' => 'Save',
            'edit' => 'Edit',
            'delete' => 'Delete',
            'approve' => 'Approve',
            'reject' => 'Reject',
            'edit_profile' => 'Edit Profile',
            'update_profile' => 'Update Profile',
            'add_principle' => 'Add Principle',
            
            // Alerts
            'confirm_delete' => 'Are you sure you want to delete this?',
            'unsaved_changes' => 'You have unsaved changes. Are you sure you want to leave?',
            'operation_success' => 'Operation completed successfully',
            'operation_failed' => 'Operation failed. Please try again.',
            'password_mismatch' => 'Passwords do not match',
            
            // Error Messages
            'error_not_logged_in' => 'Not logged in.',
            'error_invalid_field' => 'Invalid field.',
            'error_user_not_found' => 'User not found.',
            'error_login_required' => 'Please log in to continue',
            'error_login_again' => 'User not found. Please log in again.',
            'error_edit_permission' => 'Please log in to edit profiles',
            'error_password_mismatch' => 'Passwords do not match',  
            'error_passwords_mismatch_short' => 'Passwords do not match or are too short.',
            'error_password_fields_required' => 'Please fill in all password fields.',
            'error_passwords_no_match' => 'New passwords do not match.',
            'error_password_length' => 'Password must be at least 6 characters long.',
            'error_principle_validation' => 'Title must be at most 2 words and description under 777 characters.',
            'error_principle_denied_and_removed' => 'Principle denied and removed',
            
            // Success Messages
            'success_profile_updated' => '✅',
            'success_password_updated' => '✅',
            'success_principle_submitted' => '✅',
            'success_user_registered' => '✅',
            
            // Icons (using emoji for simplicity)
            'icon_edit' => '✏️',
            'icon_save' => '💾',
            'icon_cancel' => '❌',
            'icon_logout' => '⏻',
            'icon_add' => '➕',
            
            // Profile Fields & Labels
            'age' => 'Age',
            'location' => 'Location',
            'joined' => 'Joined',
            
            // Messages & Alerts
            'welcome_message' => 'Welcome to ' . ($SETTINGS['SITE_SETTINGS']['site_name'] ?? 'Principles'),
            'profile_updated' => 'Profile updated successfully',
            'principle_submitted' => 'Principle submitted for review',
            'principle_approved' => 'Principle approved',
            'principle_rejected' => 'Principle rejected',
            'login_required' => 'Please login to continue',
            'access_denied' => 'Access denied',
            
            // Pagination
            'previous' => 'Previous',
            'next' => 'Next',
            'page' => 'Page',
            'of' => 'of',
            
            // Moderation
            'pending_principles_for_moderation' => 'Pending Principles for Moderation',
            'no_pending_principles' => 'No pending principles',
            'moderation_actions' => 'Moderation Actions',
            'no_principles' => 'No principles',
        ],
        
        'other' => [
            // Navigation
            'principles' => 'Principes',
            'walkers' => 'Marcheurs',
            'profile' => 'Profil',
            'logout' => 'Déconnexion',
            'login_signup' => 'Connexion',
            
            // Authentication
            'login' => 'Connexion',
            'signup' => 'Inscription',
            'create_account' => 'Créer un compte',
            'username' => 'Nom d\'utilisateur',
            'email' => 'Email',
            'password' => 'Mot de passe',
            'confirm_password' => 'Confirmer le mot de passe',
            'first_name' => 'Prénom',
            'last_name' => 'Nom de famille',
            
            // Actions & Buttons
            'submit' => 'Soumettre',
            'cancel' => 'Annuler',
            'save' => 'Sauvegarder',
            'edit' => 'Modifier',
            'delete' => 'Supprimer',
            'approve' => 'Approuver',
            'reject' => 'Rejeter',
            'edit_profile' => 'Modifier le profil',
            'update_profile' => 'Mettre à jour le profil',
            'add_principle' => 'Ajouter un principe',
            
            // Alerts
            'confirm_delete' => 'Êtes-vous sûr de vouloir supprimer ceci ?',
            'unsaved_changes' => 'Vous avez des modifications non enregistrées. Êtes-vous sûr de vouloir partir ?',
            'operation_success' => 'Opération terminée avec succès',
            'operation_failed' => 'Opération échouée. Veuillez réessayer.',
            'password_mismatch' => 'Les mots de passe ne correspondent pas',
            
            // Error Messages
            'error_not_logged_in' => 'Non connecté.',
            'error_invalid_field' => 'Champ invalide.',
            'error_user_not_found' => 'Utilisateur non trouvé.',
            'error_login_required' => 'Veuillez vous connecter pour continuer',
            'error_login_again' => 'Utilisateur non trouvé. Veuillez vous reconnecter.',
            'error_edit_permission' => 'Veuillez vous connecter pour modifier les profils',
            'error_password_mismatch' => 'Les mots de passe ne correspondent pas',
            'error_passwords_mismatch_short' => 'Les mots de passe ne correspondent pas ou sont trop courts.',
            'error_password_fields_required' => 'Veuillez remplir tous les champs de mot de passe.',
            'error_passwords_no_match' => 'Les nouveaux mots de passe ne correspondent pas.',
            'error_password_length' => 'Le mot de passe doit contenir au moins 6 caractères.',
            'error_principle_validation' => 'Le titre doit contenir au maximum 2 mots et la description moins de 777 caractères.',
            'error_principle_denied_and_removed' => 'Principe refusé et supprimé',
            
            // Success Messages
            'success_profile_updated' => '✅',
            'success_password_updated' => '✅',
            'success_principle_submitted' => '✅',
            'success_user_registered' => '✅',
            
            // Icons (using emoji for simplicity)
            'icon_edit' => '✏️',
            'icon_save' => '💾',
            'icon_cancel' => '❌',
            'icon_logout' => '🚪',
            'icon_add' => '➕',
            
            // Profile Fields & Labels
            'age' => 'Âge',
            'location' => 'Localisation',
            'joined' => 'Rejoint',
            
            // Messages & Alerts
            'welcome_message' => 'Bienvenue sur ' . ($SETTINGS['SITE_SETTINGS']['site_name'] ?? 'Principes'),
            'profile_updated' => 'Profil mis à jour avec succès',
            'principle_submitted' => 'Principe soumis pour révision',
            'principle_approved' => 'Principe approuvé',
            'principle_rejected' => 'Principe rejeté',
            'login_required' => 'Veuillez vous connecter pour continuer',
            'access_denied' => 'Accès refusé',
            
            // Pagination
            'previous' => 'Précédent',
            'next' => 'Suivant',
            'page' => 'Page',
            'of' => 'de',
            
            // Moderation
            'pending_principles_for_moderation' => 'Principes en attente de modération',
            'no_pending_principles' => 'Aucun principe en attente',
            'moderation_actions' => 'Actions de modération',
            'no_principles' => 'Aucun principe',
        ],
    ],
];

// =============================================================================
// 🛠️ HELPER FUNCTIONS - DON'T MODIFY BELOW THIS LINE
// =============================================================================

if (!function_exists('getSetting')) {
function getSetting($key, $default = null) {
    global $SETTINGS;
    $keys = explode('.', $key);
    $value = $SETTINGS;
    foreach ($keys as $k) {
        if (isset($value[$k])) {
            $value = $value[$k];
        } else {
            return $default;
        }
    }
    return $value;
}
}

if (!function_exists('getAppText')) {
function getAppText($key, $lang = null) {
    if ($lang === null) {
        $lang = getCurrentLanguage();
    }
    $text = getSetting("INTERFACE_TEXT.{$lang}.{$key}");
    if ($text === null) {
        $text = getSetting("INTERFACE_TEXT.en.{$key}", $key);
    }
    return $text;
}
}

if (!function_exists('getCurrentLanguage')) {
function getCurrentLanguage() {
    // Only start session if one isn't already active
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (isset($_SESSION['language'])) {
        return $_SESSION['language'];
    }
    if (getSetting('LANGUAGES.auto_detect', true)) {
        // Auto-detect: Other language if browser matches, otherwise English
        $browserLang = isset($_SERVER['HTTP_ACCEPT_LANGUAGE']) ? $_SERVER['HTTP_ACCEPT_LANGUAGE'] : '';
        $otherLangCode = getSetting('LANGUAGES.other_language_code', 'fr');
        if (strpos(strtolower($browserLang), strtolower($otherLangCode)) !== false) {
            return 'other';
        }
    }
    return getSetting('LANGUAGES.default', 'en');
}
}

if (!function_exists('isModeratorBySettings')) {
function isModeratorBySettings($user_id) {
    $moderators = getSetting('MODERATORS', []);
    return in_array($user_id, $moderators);
}
}

if (!function_exists('getSiteUrl')) {
function getSiteUrl() {
    return sprintf(
        "%s://%s%s",
        isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
        $_SERVER['SERVER_NAME'],
        dirname($_SERVER['REQUEST_URI'])
    );
}
}

if (!function_exists('getSiteName')) {
function getSiteName() {
    return getSetting('SITE_SETTINGS.site_name', 'Principles');
}
}

if (!function_exists('getUISetting')) {
function getUISetting($setting, $default = null) {
    return getSetting("UI_SETTINGS.{$setting}", $default);
}
}



?>
