<?php
require_once 'user_functions.php';

// Language bar logic
if (isset($_GET['lang']) && in_array($_GET['lang'], ['en','fr'])) {
    $_SESSION['lang'] = $_GET['lang'];
}
$lang = $_SESSION['lang'] ?? get_default_lang();

if (isset($_POST['logout'])) {
    logoutUser();
    header('Location: index.php');
    exit;
}

$error = '';

// Add variables for confirm step
$show_confirm = false;
$pending_username = $_SESSION['pending_username'] ?? null;
$pending_password = $_SESSION['pending_password'] ?? null;

if (isset($_POST['confirm_account'])) {
    $confirm_password = $_POST['confirm_password'] ?? '';
    $username = $pending_username;
    $password = $pending_password;
    if ($confirm_password !== $password) {
        $error = t('error_password_mismatch', $lang);
        $show_confirm = true;
    } else {
        // Register user using the central function
        $registration_result = registerUser($username, '', $password);
        
        if ($registration_result['success']) {
            unset($_SESSION['pending_username'], $_SESSION['pending_password']);
            $_SESSION['username'] = $username;
            header('Location: profile');
            exit;
        } else {
            // This case should not happen if username was checked before
            $error = $registration_result['message'] ?? t('error_registration_failed', $lang);
            // Go back to the initial signup form
            unset($_SESSION['pending_username'], $_SESSION['pending_password']);
            $show_confirm = false;
        }
    }
} elseif ($pending_username && $pending_password) {
    $show_confirm = true;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['confirm_account'])) {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = t('error_fill_fields', $lang);
    } elseif (strlen($password) < 6) {
        $error = t('error_password_length', $lang);
    } else {
        $user = getUserByUsername($username);
        if ($user) {
            // User exists, try to log in
            if (password_verify($password, $user['password'])) {
                $_SESSION['username'] = $user['username'];
                header('Location: profile');
                exit;
            } else {
                $error = 'Username already exists and there is a password mismatch.';
            }
        } else {
            // New user, validation passed - proceed to confirmation step
            $_SESSION['pending_username'] = $username;
            $_SESSION['pending_password'] = $password;
            header('Location: signup'); // Redirect to self for confirmation
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo t('login_signup', $lang); ?> | <?php echo htmlspecialchars(getSiteName()); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Comic+Neue:wght@700&family=Bubblegum+Sans&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css" />
    <link rel="stylesheet" href="dynamic-styles.php" />
    <style>
        .auth-container {
            min-height: calc(100vh - 120px); /* Adjusted for nav and lang bar */
            display: flex;
            align-items: center;
            justify-content: center;
            /* background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%); */
            padding: 20px;
        }
        .auth-box {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 500px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 3px solid #f9a1b0;
            border-radius: 18px;
            font-size: 1.25rem;
            background: #eaf3ff;
            transition: border-color 0.3s;
        }
        .form-group input:focus {
            border-color: #f9a1b0;
            outline: none;
        }
        .btn-primary {
            width: 100%;
            padding: 10px 24px;
            background: #ffa3b0;
            color: white;
            border: none;
            border-radius: 50px;
            font-size: 1rem;
            font-family: 'Comic Neue', cursive;
            cursor: pointer;
            margin-top: 20px;
        }
        /* .btn-primary:hover {
            background: #ff7a92;
        } */
        .error-message {
            background: #ffebee;
            color: #c62828;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 20px;
            text-align: center;
        }
        .nav-container {
            width: 100%;
            max-width: 900px;
            margin: 0 auto;
        }
        .nav-left {
            display: flex;
            width: 100%;
            gap: 0;
        }
    </style>
</head>
<body>
<nav class="navbar">
    <div class="nav-container nav-flex">
        <div class="nav-left">
            <a href="index.php" class="nav-button"><?php echo t('prescription', $lang); ?></a>
            <a href="principles.php" class="nav-button"><?php echo t('principles', $lang); ?></a>
            <a href="walkers.php" class="nav-button"><?php echo t('walkers', $lang); ?></a>
            <?php if (isLoggedIn()): ?>
                <a href="profile.php" class="nav-button profile-btn"><?php echo t('profile', $lang); ?></a>
                <form method="post" style="display:inline;margin:0;padding:0;">
                    <button type="submit" name="logout" class="nav-button login-btn" style="margin-left:10px;"> <?php echo t('logout', $lang); ?> </button>
                </form>
            <?php else: ?>
                <a href="signup.php" class="nav-button login-btn"><?php echo t('login_signup', $lang); ?></a>
            <?php endif; ?>
        </div>
    </div>
</nav>

<main class="container">
    <div class="auth-container">
        <div class="auth-box">
            <?php if ($show_confirm): ?>
                <p style="text-align:center; color:#888; margin-bottom:20px;">Please re-enter your password to confirm your account.</p>
                <?php if ($error): ?>
                    <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form class="auth-form" method="POST" action="signup">
                    <div class="form-group">
                        <input type="password" id="confirm_password" name="confirm_password" placeholder="<?php echo t('confirm_password', $lang); ?>" required>
                    </div>
                    <button type="submit" name="confirm_account" class="btn btn-primary">Confirm & Create Account</button>
                </form>
            <?php else: ?>
                <?php if ($error): ?>
                    <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>
                <form class="auth-form" method="POST" action="signup">
                    <div class="form-group">
                        <input type="text" id="username" name="username" placeholder="<?php echo t('username', $lang); ?>" required maxlength="32">
                    </div>
                    <div class="form-group">
                        <input type="password" id="password" name="password" placeholder="<?php echo t('password', $lang); ?>" required minlength="6">
                    </div>
                    <button type="submit" class="btn btn-primary"><?php echo t('login_signup', $lang); ?></button>
                </form>
            <?php endif; ?>
        </div>
    </div>
</main>
<!-- <script src="script.js"></script> -->
</body>
</html> 