<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once 'user_functions.php';

// Process logout first
if (isset($_POST['logout'])) {
    logoutUser();
    header('Location: index.php');
    exit;
}

// Language bar logic
if (isset($_GET['lang']) && in_array($_GET['lang'], ['en','fr'])) {
    $_SESSION['lang'] = $_GET['lang'];
}
$lang = $_SESSION['lang'] ?? get_default_lang();
$users = array_filter(getUsers(), function($u) { return $u['username'] !== 'admin'; });

// Pagination logic
$users_per_page = getSetting('SITE_SETTINGS.principles_per_page', 10); // Use same setting as principles
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$total_users = count($users);
$total_pages = ceil($total_users / $users_per_page);
$offset = ($page - 1) * $users_per_page;

// Sorting logic
$sort_by = $_GET['sort'] ?? 'username';
$order = $_GET['order'] ?? 'asc';
$valid_sort_columns = ['username', 'joined'];
if (!in_array($sort_by, $valid_sort_columns)) {
    $sort_by = 'username';
}
usort($users, function($a, $b) use ($sort_by, $order) {
    $val_a = $a[$sort_by] ?? '';
    $val_b = $b[$sort_by] ?? '';

    $cmp = 0;
    if ($sort_by === 'joined') {
        $cmp = strtotime($val_a) <=> strtotime($val_b);
    } else {
        $cmp = strcasecmp($val_a, $val_b);
    }
    return ($order === 'asc') ? $cmp : -$cmp;
});

// Apply pagination
$users = array_slice($users, $offset, $users_per_page);

function sort_link($title, $column, $current_sort, $current_order, $lang) {
    $page = $_GET['page'] ?? 1;
    $asc_arrow = '▲';
    $desc_arrow = '▼';
    
    // Active arrow: white color, Inactive arrow: white border
    $asc_style = ($current_sort === $column && $current_order === 'asc') 
        ? 'color: white; text-shadow: 0 0 2px rgba(0,0,0,0.5);' 
        : 'color: transparent; -webkit-text-stroke: 1px white; text-stroke: 1px white;';
    $desc_style = ($current_sort === $column && $current_order === 'desc') 
        ? 'color: white; text-shadow: 0 0 2px rgba(0,0,0,0.5);' 
        : 'color: transparent; -webkit-text-stroke: 1px white; text-stroke: 1px white;';
    
    $asc_link = '<a href="?sort=' . $column . '&order=asc&page=' . $page . '&lang=' . $lang . '" style="text-decoration:none;' . $asc_style . '">' . $asc_arrow . '</a>';
    $desc_link = '<a href="?sort=' . $column . '&order=desc&page=' . $page . '&lang=' . $lang . '" style="text-decoration:none;' . $desc_style . '">' . $desc_arrow . '</a>';
    
    return t($title, $lang) . ' ' . $asc_link . $desc_link;
}



// PROFILE CHANGES MODERATION - COMMENTED OUT FOR FUTURE USE
/*
// Load pending changes for display
$pending_file = 'pending_profile_changes.json';
$pending_changes = [];
if (isModerator() && file_exists($pending_file)) {
    $json = file_get_contents($pending_file);
    $pending_changes = json_decode($json, true);
    if (!is_array($pending_changes)) $pending_changes = [];
}
*/
$pending_changes = []; // Empty array for now
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Walkers | <?php echo htmlspecialchars(getSiteName()); ?></title>
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="dynamic-styles.php">
    <style>
        body { background: #e3e6f5; }
        .walkers-page{
            padding-right: 15px;
        }
        .walkers-container {
            max-width: 400px;
            margin: 20px auto 0 auto;
            background: #fff3d6;
            border-radius: 30px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.12);
            padding: 15px 15px 25px 15px;
        }
        .walkers-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0 5px;
        }
        .walkers-table th, .walkers-table td {
            /* width: 33%; */
            padding: 12.5px 10px;
            background: #fff;
            /* border-radius: 12px; */
            font-family: 'Sniglet', Comic Sans MS, sans-serif;
            /* font-size: 1.08rem; */
            font-size: 0.75rem;
            color: #333;
            text-align: center;
        }
        .walkers-table th {
            background: #8fd3ff;
            color: #fff;
            font-size: 0.75rem;
        }
        .walkers-table th a {
            color: #fff;
            text-decoration: none;
            /* display: block; */
            /* transition: background-color 0.2s; */
        }
        .walkers-table th:hover {
            background-color: #7ac5f5;
        }
        .walkers-table thead tr th:first-child {
            border-top-left-radius: 12px;
            border-bottom-left-radius: 12px;
        }

        .walkers-table thead tr th:nth-child(2) {
            border-top-right-radius: 12px;
            border-bottom-right-radius: 12px;
        }
        .walkers-table tbody tr td:first-child {
            border-top-left-radius: 12px;
            border-bottom-left-radius: 12px;
        }

        .walkers-table tbody tr td:nth-child(2) {
            width: 55%;
            border-top-right-radius: 12px;
            border-bottom-right-radius: 12px;
      }
        .walker-username-link {
            color: #ffffff;
            text-decoration: underline;
            font-weight: bold;
            cursor: pointer;
        }
        .walker-username-link:hover {
            color: #357abd;
        }
        .walker-email {
            cursor: pointer;
            color: #888;
        }
        .walker-email.revealed {
            color: #333;
            text-decoration: none;
        }
        .nav-container {
            width: 100%;
            max-width: 900px;
            margin: 0 auto;
        }
        .nav-left{
            display: flex;
            width: 100%;
            gap: 0;
        }
        .view-email-btn {
            margin-left: 8px;
            padding: 3px 12px;
            border-radius: 6px;
            background: #7dcae6;
            color: #fff;
            border: none;
            font-size: 0.98rem;
            cursor: pointer;
            transition: background 0.2s;
        }
        .view-email-btn:hover {
            background: #4a90e2;
        }
        .pending-profile-changes-list {
            background: #fffbe6;
            border-radius: 18px;
            padding: 24px 18px 18px 18px;
            box-shadow: 0 4px 18px rgba(125,207,149,0.08);
        }
        .pending-profile-row {
            display: flex;
            align-items: center;
            gap: 18px;
            padding: 10px 0;
            border-bottom: 1px solid #eee;
            justify-content: space-between;
        }
        .pending_username_action-btns:hover{
            opacity: 0.75;
        }
        .responsive-table-wrapper {
            overflow-x: auto;
        }

        .walkers-table tbody tr td {background: #7dcf95;color:#ffffff}
        .walkers-table tbody tr:nth-child(2n) td { background: #d29ec5; }
        .walkers-table tbody tr:nth-child(3n) td { background: #9E9E9E; }
        .walkers-table tbody tr:nth-child(4n) td { background: #fdac62; }
        .walkers-table tbody tr:nth-child(5n) td { background: #dcb35a; }

        @media screen and (max-width: 768px) {
            .walkers-container{
                padding: 15px;
                margin: 0 5px;
            }
            .walkers-table th,.walkers-table td{
                font-size: 0.75rem;
            }
        }
    </style>
</head>
<body class="walkers-page">
<nav class="navbar">
    <div class="nav-container nav-flex">
        <div class="nav-left">
            <a href="index.php" class="nav-button"><?php echo t('prescription', $lang); ?></a>
            <a href="principles.php" class="nav-button"><?php echo t('principles', $lang); ?></a>
            <a href="walkers.php" class="nav-button"><?php echo t('walkers', $lang); ?></a>
            <?php if (isLoggedIn()): ?>
                <a href="profile.php" class="nav-button profile-btn"><?php echo t('profile', $lang); ?></a>
            <?php else: ?>
                <a href="signup.php" class="nav-button login-btn"><?php echo t('login_signup', $lang); ?></a>
            <?php endif; ?>
        </div>
    </div>
</nav>
<div class="walkers-container">
    <div class="responsive-table-wrapper">
        <table class="walkers-table">
            <thead>
                <tr>
                    <th><?php echo sort_link('username', 'username', $sort_by, $order, $lang); ?></th>
                    <th><?php echo sort_link('joined', 'joined', $sort_by, $order, $lang); ?></th>
                </tr>
            </thead>
            <tbody>
            <?php if (empty($users)): ?>
                <tr>
                    <td colspan="2" style="text-align:center; padding: 40px; font-size: 1.2rem; color: #888; border-radius: 0px;">
                        No walkers have joined yet. Be the first!
                    </td>
                </tr>
            <?php else: ?>
                <?php foreach ($users as $user): ?>
                    <tr>
                        <td><a href="profile?user=<?php echo urlencode($user['username']); ?>" class="walker-username-link"><?php echo htmlspecialchars($user['username']); ?></a></td>
                        <td><?php echo date('m/y', strtotime($user['joined'])); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php if ($total_pages > 1): ?>
    <div class="pagination">
        <a href="?page=<?php echo ($page - 1); ?>&sort=<?php echo $sort_by; ?>&order=<?php echo $order; ?>&lang=<?php echo $lang; ?>" class="pagination-btn" <?php if ($page <= 1) echo 'style="pointer-events:none;background:#ccc;color:#999;"'; ?>>&#8592;</a>
        <a href="?page=<?php echo ($page + 1); ?>&sort=<?php echo $sort_by; ?>&order=<?php echo $order; ?>&lang=<?php echo $lang; ?>" class="pagination-btn" <?php if ($page >= $total_pages) echo 'style="pointer-events:none;background:#ccc;color:#999;"'; ?>>&#8594;</a>
    </div>
    <?php endif; ?>
</div>

</body>
</html> 